/**
 * \file: mspin_demo_iap2_utilities.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * mySPIN Demo iAP2 Utilities
 *
 * \component: MSPIN
 *
 * \author: Bui Le Thuan / thuan.buile@vn.bosch.com
 *          Thilo Fickel ICT-ADITG/SW2 tfickel@de.adit-jv.com
 *
 * \copyright: (c) 2003 - 2013 ADIT Corporation
 *
 * \history
 * 0.1 TFickel Initial version
 *
 ***********************************************************************/

#ifndef MSPIN_DEMO_IAP2_UTILITIES_H_
#define MSPIN_DEMO_IAP2_UTILITIES_H_

#include <mspin_demo_iap2_types.h>
#include <sys/utsname.h>


class Iap2Utilites
{
private:
    static BOOL m_EndPoll;

    void  freeAccInfo(iAP2AccessoryInfo_t *pAccInfo);
    void  freeAccConfig(iAP2AccessoryConfig_t* p_iAP2AccessoryConfig);

    static S32   iap2HdlPollMqEvent(S32 mqFD);
    static S32   iap2Receive(S32 mqFD, char* recvBuf, U32 recvBufSize);

public:
    Iap2Utilites();
    ~Iap2Utilites();

    static void  parseIdRejectedMsg(iAP2IdentificationRejectedParameter* idParameter);
    static void  iap2Sleep(U32 sleep_ms);

    static void* iap2Poll(void* exinf);
    static void  iap2StopPolling(BOOL poll);
    static S32   addFDToPollFDs(iAP2PollFDs_t* getPollFDs, S32 numFDs, S32 fdToAdd, S16 eventToAdd);
    static S32   addFDsToFDset(iAP2PollFDs_t* getPollFDs, S32 numFDs, S32* maxfd, fd_set* to_readfds, fd_set* to_writefds);
    static S32   createMsgQueue(mqd_t* mq_fd, const char* mq_name, S32 flag);

    void  resetInitialParameter(iAP2InitParam_t* iAP2InitParam);

    S32   iap2Write(S32 mqFD, const char* sendBuf, U32 sendBufSize);

    S32   iap2CopyString(U8* pString, U8** ppDestination);
    S32   loadModule(iAP2InitParam_t* iap2InitParam, const char* name, int length);
    S32   unloadModule(const char* name);
};

#endif /* MSPIN_DEMO_IAP2_UTILITIES_H_ */
